/*
 * Generic Binary Heap.
 */

package cmsc420project3;

/**
 *
 * @author Jeremiah
 */
public class BinaryHeap<E> {

    // The heap itself is stored in an array.
    E[] data;
    int[] priorities;

    // The last valid entry.
    int dataSize = 0;

    BinaryHeap()
    {
        data = (E[]) new Object[7];
        priorities = new int[7];

        for(int x=0; x < 7; x++)
        {
            priorities[x] = Integer.MAX_VALUE;
        }
    }

    // Adds item to heap. Returns position in heap.
    public void addItem(E item, int priority)
    {
        if(dataSize == data.length)
        {
            expandData();
        }

        data[dataSize] = item;
        priorities[dataSize] = priority;

        int bubblePos = dataSize;
        dataSize = dataSize + 1;

        // Bubble up if needed.
        while(getParentPos(bubblePos) != bubblePos && getParentPos(bubblePos) > 0)
        {
            if(priorities[bubblePos] < priorities[getParentPos(bubblePos)])
            {
                // Heap order violation detected. Need to fix.
                swapValues(bubblePos, getParentPos(bubblePos));
            }
            bubblePos = getParentPos(bubblePos);
        }

        // Check root. Dunno why the while loop doesn't get the root, but
        // testing indicates it's needed.
        if(priorities[bubblePos] < priorities[0])
        {
            // Heap order violation detected. Need to fix.
            swapValues(bubblePos, getParentPos(bubblePos));
        }

    }
    
    public E removeMinItem()
    {
        E toReturn = data[0];

        // Move last item to root
        data[0]=data[dataSize-1];
        data[dataSize-1]=null;

        priorities[0]=priorities[dataSize-1];
        priorities[dataSize-1]=Integer.MAX_VALUE;

        dataSize =  dataSize - 1;

        recursiveBubbleFix(0);

        return toReturn;
    }


    // Fixes a tree broken by a deletion. Recursive.
    public void recursiveBubbleFix(int position)
    {
        E leftChild;
        E rightChild;

        int leftCPriority;
        int rightCPriority;

        if(getLeftChildPos(position) < dataSize)
        {
            leftChild = data[getLeftChildPos(position)];
            leftCPriority = priorities[getLeftChildPos(position)];
            // Need to fix & bubble down.
            if(leftCPriority < priorities[position])
            {
                swapValues(getLeftChildPos(position), position);
                recursiveBubbleFix(getLeftChildPos(position));
            }
        }


        if(getRightChildPos(position) < dataSize)
        {
            rightChild = data[getRightChildPos(position)];
            rightCPriority = priorities[getRightChildPos(position)];

            // Need to fix & bubble down.
            if(rightCPriority < priorities[position])
            {
                swapValues(getRightChildPos(position), position);
                recursiveBubbleFix(getRightChildPos(position));
            }
        }
    }

    // The heap abstract data type starts at 1,
    // While the array starts at 0, so I need a +1 and -1 to correct for that
    public int getParentPos(int position)
    {
        return (position+1) / 2 -1;
    }

    // Here especially I need it: 0*2=0, so the "left child" of the root
    // would be itself if I didn't correct for it!
    public int getLeftChildPos(int position)
    {
        return (position+1) * 2 -1;
    }

    public int getRightChildPos(int position)
    {
//        return (position+1) * 2 + 1 -1;
        return (position+1) * 2;
    }

    public void swapValues(int firstPos, int secondPos)
    {
        E temp = data[firstPos];
        data[firstPos] = data[secondPos];
        data[secondPos] = temp;
        int priTemp = priorities[firstPos];
        priorities[firstPos] = priorities[secondPos];
        priorities[secondPos] = priTemp;
    }

    // Expands the data when needed.
    private void expandData()
    {
        E[] newData = (E[]) new Object[data.length * 2];
        System.arraycopy(data, 0, newData, 0, data.length);
        data = newData;

        int[] newPrior = new int[priorities.length * 2];
        System.arraycopy(priorities, 0, newPrior, 0, priorities.length);
        priorities = newPrior;
    }
}
